--  Aby móc uruchomić ten przykład, upewnij się najpierw, że 
--  uruchomiłeś wcześniej SalesOrdersStructure.sql i
--  SalesOrdersData.sql w katalogu z bazami przykładowymi 

SET SCHEMA SalesOrdersSample;

-- Wyłączenie więzów integralności, aby możliwa była modyfikacja tabeli
SET INTEGRITY FOR Order_Details OFF;

-- Stworzenie kolumny wyliczeniowej z wykorzystaniem wyrażenia
ALTER TABLE Order_Details
  ADD COLUMN ExtendedPrice decimal (15, 2)
  GENERATED ALWAYS AS (QuantityOrdered * QuotedPrice);

-- Powtórne włączenie więzów integralności
SET INTEGRITY FOR Order_Details IMMEDIATE CHECKED FORCE GENERATED;

-- Założenie indeksu na kolumnie wyliczeniowej
CREATE INDEX Order_Details_ExtendedPrice
ON Order_Details (ExtendedPrice);

-- Można teraz posprzątać
ALTER TABLE Order_Details DROP COLUMN ExtendedPrice;

CALL SYSPROC.ADMIN_CMD('REORG TABLE SALESORDERSSAMPLE.ORDER_DETAILS');